#include <algorithm>
#include <iostream>
#include <queue>
#include <vector>

using namespace std;

void bfs(vector<vector<int>>& adj, int s, int target, vector<int>& path) 
{
    queue<pair<int,vector<int>>> q;  

    vector<bool> visited(adj.size(), false);

    visited[s] = true;
    q.push({s,{}});

    while (!q.empty())
    {
        auto curr = q.front();
        q.pop();
		
		if (curr.first == target)
		{
			path.insert(path.begin(), curr.second.begin(), curr.second.end());
			path.push_back(target);
			return;
		}

        for (int x : adj[curr.first])
        {
            if (!visited[x])
            {
                visited[x] = true;
                q.push({x, {}});
				auto& g = q.back().second;
				g.insert(g.begin(),curr.second.begin(), curr.second.end());
				g.push_back(curr.first);
				int b = 0;
            }
        }
    }
}


typedef pair<int, int> node_edge;
typedef pair<int, int> help_value;
int main()
{
	int node_count, edge_count, inquiry_count, parameter;
	cin >> node_count;
	cin >> edge_count;
	cin >> inquiry_count;
	cin >> parameter;
	vector<int> node_values;
	vector<node_edge> edges;
	vector<vector<int>> edg2(edge_count);
	vector<help_value> inquiry_value;
	for (int i = 0; i < node_count; ++i)
	{
		int t;
		cin >> t;
		node_values.push_back(t);
	}
	for (int i = 0; i < edge_count; ++i)
	{
		int t1,t2;
		cin >> t1;
		cin >> t2;
		edg2[t1 - 1].push_back(t2 - 1);
		edg2[t2 - 1].push_back(t1 - 1);
		edges.emplace_back(t1,t2);
	}
	for (int i = 0; i < inquiry_count; ++i)
	{
		int t1,t2;
		cin >> t1;
		cin >> t2;
		inquiry_value.emplace_back(t1,t2);
	}

	int ans = 0;
	for (int i = 0; i < inquiry_count; ++i)
	{
		auto& inquiry = inquiry_value[i];
		int a = (inquiry.first + ans * parameter - 1) % node_count;
		int b = (inquiry.second + ans * parameter - 1) % node_count;
		vector<int> path;
		vector<int> vls;
		vls.reserve(path.size());
		bfs(edg2, a, b, path);
		for (int value : path)
		{
			vls.push_back(node_values[value]);
		}
		sort(vls.begin(), vls.end());
		int ind = static_cast<int>(ceil(static_cast<double>(path.size()) / 2.0) - 1);
		int median = vls[ind];
		cout << median << "\n";
		ans = median;
	}
}